import React from 'react';
import CircularProgress from '@material-ui/core/CircularProgress';
import useStyles from './styles';

type Props = {
    strings: object
};

function CheckForUpdates({ strings }: Props) {
    const classes = useStyles();
    return (
        <div className={classes.checkingForUpdatesContainer}>
            <CircularProgress
                classes={{ circleIndeterminate: classes.progressCircle }}
                size={27}
                className={classes.progress}
            />
            <div className={classes.checkingForUpdates}>
                {strings.update_device_checking_for_updates}
            </div>
        </div>
    );
}

export default CheckForUpdates;
